% KJAR.cls
\NeedsTeXFormat{LaTeX2e}
\ProvidesClass{KJAR}[2025/12/20 Kurdistan Journal of Applied Research]

% ---------------- Base class ----------------
\LoadClass[10pt,a4paper]{article}

% ---------------- Packages ----------------
\RequirePackage[utf8]{inputenc}
\RequirePackage[T1]{fontenc}
\RequirePackage{geometry}
\RequirePackage{setspace}
\RequirePackage{graphicx}
\RequirePackage{xcolor}
\RequirePackage{tcolorbox}
\RequirePackage{hyperref}
\RequirePackage{float}
\RequirePackage{booktabs}
\RequirePackage{mathpazo} % Palatino font
\RequirePackage{fancyhdr}

% ---------------- Header spacing control ----------------
\setlength{\headheight}{12pt}  % header height
\setlength{\headsep}{12pt}     % space between header rule and text

% ---------------- Colors ----------------
\definecolor{abstractblue}{RGB}{225,235,245}

% ---------------- Hyperref ----------------
\hypersetup{hidelinks}

% ---------------- Page style control ----------------
\AtBeginDocument{%
  \pagestyle{KJARstyle}         % default for all pages
  \thispagestyle{KJARfirstpage} % footer ONLY on page 1
  \setcounter{page}{1}
}

% ---------------- Journal header command ----------------
\newcommand{\KJARHeader}{%
\begin{center}
  \setlength{\fboxsep}{2pt}
  \colorbox{white}{%
    \begin{minipage}{\textwidth}

      % Logo
      \begin{minipage}[c]{0.3\textwidth}
        \includegraphics[height=1.4cm]{KJAR Logo.png}
      \end{minipage}%
      \hfill
      % Journal name and ISSN
      \begin{minipage}[c]{0.65\textwidth}
        \raggedleft
        {Kurdistan Journal of Applied Research (KJAR)}\\
        Print-ISSN: 0000-0000 | Electronic-ISSN: 0000-0000
      \end{minipage}

      \vspace{5pt}
      \noindent\rule{\textwidth}{0.8pt}

      % Original Article & update link
      \noindent
      \begin{minipage}[t]{0.5\textwidth}
        \vspace{5pt} % reduce space between rule and text
        \textit{Original Article}
      \end{minipage}%
      \hfill
      \begin{minipage}[t]{0.45\textwidth}
        \raggedleft
        \vspace{-5pt}
        \href{https://example.com/update}{%
          \includegraphics[width=1.39in,height=0.3in]{checkforupdate.png}%
        }
      \end{minipage}

    \end{minipage}%
  }
\end{center}
\vspace{1em}
}

% ---------------- Abstract environment ----------------
\newenvironment{KJARabstract}{%
\noindent
\begin{tcolorbox}[
  colback=abstractblue,
  colframe=white,
  boxrule=0pt,
  arc=2pt,
  width=4.5in,      % fixed width
  height=4.25in,    % minimum height
  left=8pt,
  right=8pt,
  top=8pt,
  bottom=8pt,
  enhanced,         % allows advanced features
  breakable         % allows box to grow vertically if content exceeds min-height
]
\fontsize{9}{11}\selectfont
\textbf{Abstract:}
}{%
\end{tcolorbox}
}

% ---------------- Left Sidebar environment ----------------
\newenvironment{KJARsidebar}{%
\begin{minipage}[t]{1.6in} % left sidebar width
\vspace{-300pt} 
\fontsize{7}{9}\selectfont
\setlength{\parskip}{0.5em} % optional spacing between lines
\noindent
\textbf{Submitted:} \\ 
\textbf{Revised:} \\
\textbf{Accepted:} \\[1em]

\textbf{* Corresponding Author:} (will be filled after acceptance)\\[0.5em]

\textbf{Keywords:} keyword 1, keyword 2, keyword 3 (List five to eight pertinent keywords specific to the article yet should not be a complete repetition of the title.)\\[1em]

\textbf{\color{black!50!yellow}%
  \setlength{\fboxsep}{2pt}%
  \colorbox{yellow!40}{\strut How to cite this paper:}
}\\[0.5em]

\includegraphics[width=2.7cm]{Copyright.png} \\[-0.1em]
{\footnotesize
  Copyright © 2025 by the authors. This article is an open access article distributed under the terms and
  conditions of the Creative Commons Attribution (CC BY-NC-ND 4.0)
}
}{%
\end{minipage}
}

% ---------------- DOI ----------------
\newcommand{\KJARdoi}{http://doi.org/00.00000/science.0000.0.0}

% ---------------- Header & Footer (KJAR Style) ----------------
\fancypagestyle{KJARstyle}{%
  \fancyhf{} % clear all headers and footers

  % Header
  \fancyhead[L]{\fontsize{9}{11}\selectfont\itshape \KJARdoi}
  \fancyhead[R]{\fontsize{9}{11}\selectfont\thepage}

  \renewcommand{\headrulewidth}{0.4pt}
  \renewcommand{\footrulewidth}{0pt} % no footer on normal pages
}

\fancypagestyle{KJARfirstpage}{%
  \fancyhf{} % clear all headers and footers

  % Footer with extra space from the rule
  \fancyfoot[L]{%
    \fontsize{9}{11}\selectfont
    \raisebox{-1.5mm}[0pt][0pt]{KJAR. June 0000, volume 00, issue 0} % shift up/down
  }

  \fancyfoot[R]{%
    \fontsize{9}{11}\selectfont
    \raisebox{-1.5mm}[0pt][0pt]{kjar.spu.edu.iq} % shift up/down
  }

  % Footer line thickness
  \renewcommand{\footrulewidth}{0.4pt}
  \renewcommand{\headrulewidth}{0pt} % no header line on first page
}

% ---------------- Header spacing ----------------
\setlength{\headheight}{15pt}  % height of the header itself
\setlength{\headsep}{6pt}      % distance from bottom of header to top of text
